// Autor: Marin Tomic

#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <algorithm>

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR (i, 0, n)
#define _ << " _ " <<
#define TRACE(x) cerr << #x << " = " << x << endl
#define debug(...) fprintf(stderr, __VA_ARGS__)

// #define TRACE(x)
// #define debug(...)

using namespace std;

typedef long long llint;

struct mlin { int x1, y1, x2, y2; };

mlin M[] = {
  {0, 0, 0, 6},
  {0, 0, 6, 0},
  {6, 0, 6, 6},
  {0, 6, 6, 6},
  {1, 1, 1, 5},
  {1, 1, 5, 1},
  {5, 1, 5, 5},
  {1, 5, 5, 5},
  {2, 2, 2, 4},
  {2, 2, 4, 2},
  {4, 2, 4, 4},
  {2, 4, 4, 4},
  {3, 0, 3, 2},
  {0, 3, 2, 3},
  {4, 3, 6, 3},
  {3, 4, 3, 6}
};

int p[7][7];
bool flag[2][7][7];

void check(mlin m) {
  int dx = m.x1 != m.x2, dy = m.y1 != m.y2;
  int cnt[] = {0, 0, 0};
  int tot = m.x2-m.x1 + m.y2-m.y1;
  for (int d = 0; d <= tot; ++d)
    ++cnt[p[m.x1 + d*dx][m.y1 + d*dy]];

  if (cnt[1] == 3 || cnt[2] == 3)
    for (int d = 0; d <= tot; ++d)
      flag[dx][m.x1 + d*dx][m.y1 + d*dy] = true;
}

char ans[][8] = {
  "*..*..*",
  ".*.*.*.",
  "..***..",
  "***.***",
  "..***..",
  ".*.*.*.",
  "*..*..*"
};

int main(void) {
  int n;
  scanf("%d", &n);
  REP (i, n) {
    char r, s, b;
    scanf(" %c %c %c", &r, &s, &b);
    p[r-'a'][s-'1'] = b == 'b' ? 1 : 2;
  }

  REP (i, int(sizeof(M)/sizeof(mlin))) check(M[i]);

  REP (i, 7) {
    REP (j, 7) {
      if (p[i][j] == 1) ans[i][j] = 'o';
      if (p[i][j] == 2) ans[i][j] = 'x';
      if (flag[0][i][j]) ans[i][j] = '-';
      if (flag[1][i][j]) ans[i][j] = '|';
      if (flag[0][i][j] && flag[1][i][j]) ans[i][j] = '+';
      printf("%c", ans[i][j]);
    }
    printf("\n");
  }
  
  return 0;
}
